//				file	VBto_Converter.h
// This is a part of the VBto Converter (www.vbto.net). Copyright (C) 2005-2009 StressSoft Company Ltd. All rights reserved.
//

#ifndef VBto_Converter_AddFunctions_H
#define VBto_Converter_AddFunctions_H

#include <assert.h>

 
 CString GetWindowText(const CWnd *wnd);
 inline CString GetWindowText(const CWnd &wnd) { return GetWindowText(&wnd); }
 CString LCase(const CString &csI);
 
 CString Format(const char *fmt, ...);
 
 CString FormatVB(short  val, const char *vbfmt=NULL);
 CString FormatVB(int    val, const char *vbfmt=NULL);
 CString FormatVB(long   val, const char *vbfmt=NULL);
 CString FormatVB(float  val, const char *vbfmt=NULL);
 CString FormatVB(double val, const char *vbfmt=NULL);
 CString FormatVB(const char *str  , const char *vbfmt=NULL);
 CString FormatVB(const CString &cs, const char *vbfmt=NULL);
 
 CString Str(short val);
 CString Str(int val);
 CString Str(unsigned int val);
 CString Str(float val);
 CString Str(double val);
 CString Str(bool val);
 CString Str(const CComVariant &val);
 inline CString Str(const CString &cs) { return cs; }
 inline CString Str(const char *ps) { return CString(ps); }

 
 double CDbl(const CString &s);
 inline double CDbl(double d) { return d; }
 double Round(double d);
 void DoEvents(HWND hWndEvents=NULL);	// - remove any messages that may be in the queue
 void PrintLine(HANDLE hf, const CString &cs="");
 void Print(HANDLE hf, const CString &cs="");
 
 #define kTP	15
 extern int CurrentX, CurrentY;
 
 void DrawString(CWnd *wnd, const CString &Str, float x, float y);
 void DrawString(CWnd *wnd, const CString &Str);
 
inline DATE vbNow() {
	return COleDateTime::GetCurrentTime();
}
inline DATE vbDate() {
	return (long)COleDateTime::GetCurrentTime();
}
inline DATE vbTime() {
	DATE dt = COleDateTime::GetCurrentTime();
	return dt - (long)dt;
}

  // === External Consts: ===
 #define vbMonday	2


#endif // VBto_Converter_AddFunctions_H
